/*
 * Examples  : Arduino Experiment Examples By....ETT CO.,LTD
 * Program   : MCP3424_OneShortConversion
 * Hardware  : ET-EASY MEGA1280 (Arduino Mega Compatible)
 *           : ET-MINI MCP3424 I2C Interface with Arduino  
 * Function  : Measure ADC Voltage
 */

#include <Wire.h>                           // I2C Bus
#include <MCP3424.h>                        // MCP3424 Library

MCP3424 MCP(0);                             // Setup MCP3424 Hardware Address = 0
long Voltage;

void setup()
{ 
  Serial.begin(9600);                       // start serial for output
  
  //Channel 1, 16 bits resolution, one-shot mode, amplifier gain = 1
  MCP.Configuration(1,                      // ADC Channel(1,2,3,4) = 1
                    18,                     // Resolution(12,14,16,18) = 18-Bit
                    0,                      // ADC Mode(0,1) = 0:One-Short 
                    1);                     // Amplifier gain(1,2,4,8) = 1
}

void loop()
{
  MCP.NewConversion();                      // New conversion is initiated
  Voltage = MCP.Measure();                  // Measure, note that the library waits for a complete conversion
  Serial.print("Voltage = ");               // print result
  Serial.print(Voltage);
  Serial.println(" microVolt");             
  
  delay (1000);
}

